Imports System.Windows.Forms

Public Class DirtyState
    ' Symbolic constants for events
    Public Enum DirtyState_Events
        DIRTY_EVENT
        APPLY_EVENT
        SAVE_EVENT
        REVERT_EVENT
    End Enum

    ' Symbolic constants for states
    Private Shared myBothDirty As New BothDirty()
    Private Shared myFileDirty As New FileDirty()
    Private Shared myParamDirty As New ParamDirty()
    Private Shared myNotDirty As New NotDirty()

    Private parameters As Parameters
    Private apply, save, revert As Button

    ' Having this private constructor prevents classes outside
    ' of this class from creating an instance of this class.
    Private Sub New() ' constructor()
    End Sub 'New

    '
    ' Initialize the state machine and return its initial state.
    '
    ' p The parameters object that this object will work with
    ' apply The apply button to be enabled/disabled
    ' save The save button to be enabled/disabled
    ' revert The revert button to be enabled/disabled
    Friend Shared Function Start(ByVal p As Parameters, ByVal apply As Button, ByVal save As Button, ByVal revert As Button) As DirtyState
        Dim d As New DirtyState()
        d.parameters = p
        d.apply = apply
        d.save = save
        d.revert = revert
        myNotDirty.Enter()
        Return myNotDirty
    End Function

    '
    ' Respond to a given event with the next state.
    ' e - An event code
    ' returns - the next state
    Protected Overridable Function NextState(ByVal e As Integer) As DirtyState
        ' This non-overridden method should never be called.
        Throw New System.ApplicationException("Method not overridden")
    End Function

    '
    ' Respond to the given event by determining the next
    ' current state and transitioning to it if it is a
    ' different state.
    '
    Public Function ProcessEvent(ByVal e As Integer) As DirtyState
        Dim myNextState As DirtyState = NextState(e)
        If Me Is myNextState Then
            myNextState.Enter()
        End If
        Return myNextState
    End Function 'ProcessEvent

    '
    ' This method is called when this object is becomes the current state.
    '
    Protected Overridable Sub Enter()
    End Sub

    ' class to represent state for when the fields of the dialog do not match
    ' the file or the working parameter values.
    Private Class BothDirty
        Inherits DirtyState

        '
        ' Respond to a given event with the next state.
        '
        ' e - An event code
        ' returns - the next state
        Protected Overrides Function NextState(ByVal e As Integer) As DirtyState
            Select Case e
                Case DirtyState_Events.DIRTY_EVENT
                    Return Me
                Case DirtyState_Events.APPLY_EVENT
                    If parameters.ApplyParam() Then
                        myFileDirty.Enter()
                        Return myFileDirty
                    End If
                Case DirtyState_Events.SAVE_EVENT
                    If parameters.SaveParam() Then
                        myParamDirty.Enter()
                        Return myParamDirty
                    End If
                Case DirtyState_Events.REVERT_EVENT
                    If parameters.RevertParam() Then
                        myParamDirty.Enter()
                        Return myParamDirty
                    End If
                Case Else
                    Throw New System.ApplicationException("unexpected event " & e)
            End Select
            Return Nothing
        End Function 'NextState

        '
        ' This method is called when this object is becomes the current state.
        '
        Protected Overrides Sub Enter()
            apply.Enabled = True
            revert.Enabled = True
            save.Enabled = True
        End Sub
    End Class 'BothDirty

    ' class to represent state for when the fields of the dialog match
    ' the working parameter values but not the file.
    Private Class FileDirty
        Inherits DirtyState

        '
        ' Respond to a given event with the next state..
        '
        ' e - An event code
        ' returns - the next state
        Protected Overrides Function NextState(ByVal e As Integer) As DirtyState
            Select Case e
                Case DirtyState_Events.DIRTY_EVENT
                    myBothDirty.Enter()
                    Return myBothDirty
                Case DirtyState_Events.SAVE_EVENT
                    If parameters.SaveParam() Then
                        myNotDirty.Enter()
                        Return myNotDirty
                    End If
                Case DirtyState_Events.REVERT_EVENT
                    If parameters.RevertParam() Then
                        myParamDirty.Enter()
                        Return myParamDirty
                    End If
                Case Else
                    Throw New System.ApplicationException("unexpected event " & e)
            End Select
            Return Nothing
        End Function 'NextState

        '
        ' This method is called when this object is becomes the current state.
        '
        Protected Overrides Sub Enter()
            apply.Enabled = False
            revert.Enabled = True
            save.Enabled = True
        End Sub 'Enter
    End Class 'FileDirty

    ' class to represent state for when the fields of the dialog match
    ' the file but not the working parameter values.
    Private Class ParamDirty
        Inherits DirtyState

        '
        ' Respond to a given event with the next state..
        '
        ' e - An event code
        ' returns - the next state
        Protected Overrides Function NextState(ByVal e As Integer) As DirtyState
            Select Case e
                Case DirtyState_Events.DIRTY_EVENT
                    myBothDirty.Enter()
                    Return myBothDirty
                Case DirtyState_Events.APPLY_EVENT
                    If parameters.ApplyParam() Then
                        myNotDirty.Enter()
                        Return myNotDirty
                    End If
                Case Else
                    Throw New System.ApplicationException("unexpected event " & e)
            End Select
            Return Nothing
        End Function 'NextState

        '
        ' This method is called when this object is becomes the current state.
        '
        Protected Overrides Sub Enter()
            apply.Enabled = True
            revert.Enabled = False
            save.Enabled = False
        End Sub
    End Class 'ParamDirty

    '
    ' class to represent state for when the fields of the dialog match
    ' the file and the working parameter values.
    '
    Private Class NotDirty
        Inherits DirtyState

        '
        ' Respond to a given event with the next state..
        '
        ' e - An event code
        ' returns - the next state
        Protected Overrides Function NextState(ByVal e As Integer) As DirtyState
            Select Case e
                Case DirtyState_Events.DIRTY_EVENT
                    myBothDirty.Enter()
                    Return myBothDirty
                Case Else
                    Throw New System.ApplicationException("unexpected event " & e)
            End Select
        End Function 'NextState

        '
        ' This method is called when this object is becomes the current state.
        '
        Protected Overrides Sub Enter()
            apply.Enabled = False
            revert.Enabled = False
            save.Enabled = False
        End Sub
    End Class 'NotDirty

End Class 'DirtyState
